<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Pricing_Table_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-pricing-table';
	}

	public function get_title() {
		return _x( 'Pricing Table', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions'        => array( 'widgetType' => $name ),
			'fields'            => array(
				array(
					'field'       => 'pricing_heading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Pricing Heading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'amount_value',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Amount Value', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'amount_label',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Amount Label', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'amount_symbol_before',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Symbol Before', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'amount_symbol_after',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Symbol After', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'button_title',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Button Title', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				'link' => array(
					'field'       => 'link',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Button Link', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINK',
				),
			),
			'integration-class' => 'WPML_Arrigo_Elementor_Pricing_Table_Widget',
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Heading
		 */
		$this->add_control(
			'pricing_heading',
			array(
				'label'       => _x( 'Heading', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => _x( 'Edit heading...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Amount Heading
		 */
		$this->add_control(
			'amount_heading',
			array(
				'label'     => _x( 'Amount', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		/**
		 * Amount Value
		 */
		$this->add_control(
			'amount_value',
			array(
				'label'       => _x( 'Value', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '100',
			)
		);

		/**
		 * Amount Label
		 */
		$this->add_control(
			'amount_label',
			array(
				'label'       => _x( 'Label', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 'Edit label',
			)
		);

		/**
		 * Symbol Before
		 */
		$this->add_control(
			'amount_symbol_before',
			array(
				'label'   => _x( 'Symbol Before', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => '$',
			)
		);

		/**
		 * Symbol After
		 */
		$this->add_control(
			'amount_symbol_after',
			array(
				'label'   => _x( 'Symbol After', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => null,
			)
		);

		/**
		 * Features Heading
		 */
		$this->add_control(
			'features_heading',
			array(
				'label'     => _x( 'Features', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$repeater = new \Elementor\Repeater();

		/**
		 * Feature
		 */
		$repeater->add_control(
			'feature',
			array(
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		/**
		 * Features Repeater Control
		 */
		$this->add_control(
			'features',
			array(
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ feature }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Button
		 */
		$this->start_controls_section(
			'button_section',
			array(
				'label' => _x( 'Button', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Button Title
		 */
		$this->add_control(
			'button_title',
			array(
				'label'       => _x( 'Title', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => __( 'Button', 'arrigo' ),
			)
		);

		/**
		 * Button URL
		 */
		$this->add_control(
			'button_link',
			array(
				'label'         => _x( 'Link', 'Elementor Widget', 'arrigo' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'placeholder'   => _x( 'https://...', 'Elementor Widget', 'arrigo' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		/**
		 * Button Style
		 */
		$this->add_control(
			'button_style',
			array(
				'label'       => _x( 'Style', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'button_bordered' => __( 'Bordered', 'arrigo' ),
					'button_solid'    => __( 'Solid', 'arrigo' ),
				),
				'default'     => 'button_solid',
			)
		);

		/**
		 * Button Color
		 */
		$this->add_control(
			'button_color',
			array(
				'label'       => _x( 'Color', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'button_accent' => _x( 'Accent', 'Elementor Widget', 'arrigo' ),
					'button_dark'   => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
					'button_light'  => _x( 'Light', 'Elementor Widget', 'arrigo' ),
					'button_black'  => _x( 'Black', 'Elementor Widget', 'arrigo' ),
					'button_white'  => _x( 'White', 'Elementor Widget', 'arrigo' ),
				),
				'default'     => 'button_accent',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Style
		 */
		$this->start_controls_section(
			'style_section',
			array(
				'label' => _x( 'Style', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * Featured Highlight
		 */
		$this->add_control(
			'is_pricing_featured',
			array(
				'label'        => _x( 'Enable Featured Highlight', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'default'      => null,
				'return_value' => 'figure-pricing_featured',
			)
		);

		/**
		 * Equal Height Pricing Tables
		 */
		$this->add_control(
			'is_height_equal',
			array(
				'label'       => _x( 'Set height to the tallest pricing table.', 'Elementor Widget', 'arrigo' ),
				'description' => _x( 'Useful if you have the pricing tables of different heights. Applicable for the current row in layout.', 'Elementor Widget', 'arrigo' ),
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'default'     => 'yes',
				'selectors'   => array(
					'{{WRAPPER}}' => 'height: 100%;',
					'{{WRAPPER}} .elementor-widget-container' => 'height: 100%;',
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'pricing_heading' );
		$this->add_inline_editing_attributes( 'amount_value' );
		$this->add_inline_editing_attributes( 'amount_label' );
		$this->add_inline_editing_attributes( 'amount_symbol_before' );
		$this->add_inline_editing_attributes( 'amount_symbol_after' );
		$this->add_inline_editing_attributes( 'button_title' );
		?>
			<div class="figure-pricing <?php echo $settings['is_pricing_featured']; ?>">
				<?php if ( ! empty( $settings['pricing_heading'] ) ) : ?>
					<div class="figure-pricing__header">
						<div class="figure-pricing__line"></div>
						<h3 <?php $this->print_render_attribute_string( 'pricing_heading' ); ?>><?php echo $settings['pricing_heading']; ?></h3>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $settings['amount_value'] ) || ! empty( $settings['amount_label'] ) ) : ?>
					<div class="figure-pricing__cost">
						<?php if ( ! empty( $settings['amount_value'] ) ) : ?>
							<div class="figure-pricing__amount">
								<span <?php $this->print_render_attribute_string( 'amount_value' ); ?>><?php echo $settings['amount_value']; ?></span>
								<?php if ( ! empty( $settings['amount_symbol_before'] ) ) : ?>
									<div class="figure-pricing__cost-sign figure-pricing__cost-sign_before">
										<span <?php $this->print_render_attribute_string( 'amount_symbol_before' ); ?>><?php echo $settings['amount_symbol_before']; ?></span>
									</div>
								<?php endif; ?>
								<?php if ( ! empty( $settings['amount_symbol_after'] ) ) : ?>
									<div class="figure-pricing__cost-sign figure-pricing__cost-sign_after">
										<span <?php $this->print_render_attribute_string( 'amount_symbol_after' ); ?>><?php echo $settings['amount_symbol_after']; ?></span>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if ( ! empty( $settings['amount_label'] ) ) : ?>
							<div class="figure-pricing__label">
								<span <?php $this->print_render_attribute_string( 'amount_label' ); ?>><?php echo $settings['amount_label']; ?></span>
							</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $settings['features'] ) ) : ?>
					<ul class="figure-pricing__features">
						<?php foreach ( $settings['features'] as $index => $item ) : ?>
							<?php
								$rowKey = $this->get_repeater_setting_key( 'feature', 'features', $index );
								$this->add_inline_editing_attributes( $rowKey );
							?>
							<li class="figure-pricing__feature">
								<span <?php $this->print_render_attribute_string( $rowKey ); ?>><?php echo $item['feature']; ?></span>
							</li>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
				<?php if ( ! empty( $settings['button_title'] ) ) : ?>
					<div class="figure-pricing__wrapper-button">
						<?php
							$this->add_render_attribute(
								'button',
								array(
									'class' => array( 'button', 'button_fullwidth', $settings['button_style'], $settings['button_color'] ),
									'href'  => $settings['button_link']['url'],
								)
							);

						if ( $settings['button_link']['is_external'] ) {
							$this->add_render_attribute( 'button', 'target', '_blank' );
						}

						if ( $settings['button_link']['nofollow'] ) {
							$this->add_render_attribute( 'button', 'rel', 'nofollow' );
						}
						?>
						<a <?php $this->print_render_attribute_string( 'button' ); ?>><span <?php $this->print_render_attribute_string( 'button_title' ); ?>><?php echo $settings['button_title']; ?></span></a>
					</div>
				<?php endif; ?>
			</div>
		<?php
	}

	protected function content_template() {
		?>
			<#
				var target = settings.button_link.is_external ? ' target="_blank"' : '';
				var nofollow = settings.button_link.nofollow ? ' rel="nofollow"' : '';

				view.addInlineEditingAttributes( 'pricing_heading' );
				view.addInlineEditingAttributes( 'amount_value' );
				view.addInlineEditingAttributes( 'amount_label' );
				view.addInlineEditingAttributes( 'amount_symbol_before' );
				view.addInlineEditingAttributes( 'amount_symbol_after' );
				view.addInlineEditingAttributes( 'button_title' );
			#>
			<div class="figure-pricing {{{ settings.is_pricing_featured }}}">
				<# if (settings.pricing_heading) { #>
					<div class="figure-pricing__header">
						<div class="figure-pricing__line"></div>
						<h3 {{{ view.getRenderAttributeString( 'pricing_heading' ) }}}>{{{ settings.pricing_heading }}}</h3>
					</div>
				<# } #>
				<# if (settings.amount_value || settings.amount_label) { #>
					<div class="figure-pricing__cost">
						<# if (settings.amount_value) { #>
							<div class="figure-pricing__amount">
								<span {{{ view.getRenderAttributeString( 'amount_value' ) }}}>{{{ settings.amount_value }}}</span>
								<# if (settings.amount_symbol_before) { #>
									<div class="figure-pricing__cost-sign figure-pricing__cost-sign_before">
										<span {{{ view.getRenderAttributeString( 'amount_symbol_before' ) }}}>{{{ settings.amount_symbol_before }}}</span>
								</div>
								<# } #>
								<# if (settings.amount_symbol_after) { #>
									<div class="figure-pricing__cost-sign figure-pricing__cost-sign_after">
										<span {{{ view.getRenderAttributeString( 'amount_symbol_after' ) }}}>{{{ settings.amount_symbol_after }}}</span>
								</div>
								<# } #>
							</div>
						<# } #>
						<# if (settings.amount_label) { #>
							<div class="figure-pricing__label">
								<span {{{ view.getRenderAttributeString( 'amount_label' ) }}}>{{{ settings.amount_label }}}</span>
							</div>
						<# } #>
					</div>
				<# } #>
				<# if (settings.features.length ) { #>
					<ul class="figure-pricing__features">
						<# _.each( settings.features, function(item, index) { #>
							<#
								var rowKey = view.getRepeaterSettingKey( 'feature', 'features', index );
								view.addInlineEditingAttributes( rowKey );
							#>
							<li class="figure-pricing__feature">
								<span {{{ view.getRenderAttributeString( rowKey ) }}}>{{{ item.feature }}}</span>
							</li>
						<# }); #>
					</ul>
				<# } #>
				<# if (settings.button_title) { #>
					<#
						view.addRenderAttribute(
							'button', {
								'class': [ 'button', 'button_fullwidth', settings.button_style, settings.button_color ],
								'href': settings.button_link.url,
							}
						);

						if ( settings.button_link.is_external ) {
							view.addRenderAttribute( 'button', 'target', '_blank' );
						}

						if ( settings.button_link.nofollow ) {
							view.addRenderAttribute( 'button', 'rel', 'nofollow' );
						}
					#>
					<div class="figure-pricing__wrapper-button">
						<a {{{ view.getRenderAttributeString( 'button' ) }}}><span {{{ view.getRenderAttributeString( 'button_title' ) }}}>{{{ settings.button_title }}}</span></a>
					</div>
				<# } #>
			</div>
		<?php
	}
}
