<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Parallax_Background_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-parallax-background';
	}

	public function get_title() {
		return _x( 'Parallax Background', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	protected function register_controls() {
		/**
		 * Section Image
		 */
		$this->start_controls_section(
			'image_section',
			array(
				'label' => _x( 'Image', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Image Src
		 */
		$this->add_control(
			'image',
			array(
				'label'   => _x( 'Choose Image', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
			)
		);

		/**
		 * Image Fit
		 */
		$this->add_control(
			'image_fit',
			array(
				'label'     => _x( 'Image Fit Mode', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => array(
					'contain' => array(
						'title' => _x( 'Contain', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-image-before-after',
					),
					'cover'   => array(
						'title' => _x( 'Cover', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-image',
					),
				),
				'default'   => 'cover',
				'toggle'    => false,
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		/**
		 * Min Height
		 */

		$this->add_responsive_control(
			'min_height',
			array(
				'label'      => _x( 'Minimum Height', 'Elementor Widget', 'arrigo' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'default'    => array(
					'size' => 400,
					'unit' => 'px',
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1440,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'size_units' => array( 'px', 'vh' ),
				'selectors'  => array(
					'{{WRAPPER}} .parallax-background' => 'min-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .parallax-background:after' => 'content: ""; min-height: inherit;', // Hack for IE11
				),
				'condition'  => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		/**
		 * Image Parallax
		 */
		$this->add_control(
			'image_parallax',
			array(
				'label'     => _x( 'Enable parallax', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		/**
		 * Image Parallax Speed
		 */
		$this->add_control(
			'image_parallax_speed',
			array(
				'label'     => _x( 'Parallax Speed', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'factor' => array(
						'min'  => -1.0,
						'max'  => 2.0,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'factor',
					'size' => 0.9,
				),
				'condition' => array(
					'image_parallax' => 'yes',
					'image!'         => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'image', 'class', 'parallax-background' );

		if ( $settings['image_parallax'] ) {
			$this->add_render_attribute(
				'image',
				array(
					'class'         => 'jarallax',
					'data-speed'    => is_array( $settings['image_parallax_speed'] ) ? $settings['image_parallax_speed']['size'] : 0,
					'data-img-size' => $settings['image_fit'],
				)
			);
			$this->add_render_attribute( 'img', 'class', 'jarallax-img' );
		}
		?>
		<div <?php $this->print_render_attribute_string( 'image' ); ?>>
			<?php
				arr_the_lazy_image(
					array(
						'id'    => $settings['image']['id'],
						'type'  => 'image',
						'class' => array(
							'wrapper' => false,
							'image'   => array( 'jarallax-img', 'of-' . $settings['image_fit'] ),
						),
					)
				);
			?>
		</div>
		<?php
	}
}
