<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Masthead_Intro_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-masthead-intro';
	}

	public function get_title() {
		return _x( 'Masthead Intro', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'heading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Heading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'subheading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Subheading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'button_title',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Button Title', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				'link' => array(
					'field'       => 'button_link',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Button Link', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINK',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Heading
		 */
		$this->add_control(
			'heading',
			array(
				'label'       => _x( 'Heading', 'Elementor Widget', 'arrigo' ),
				'description' => sprintf(
					'%1$s <u>%2$s</u> %3$s<br>',
					_x( 'You can highlight words by making them', 'Elementor Widget', 'arrigo' ),
					_x( 'Underlined', 'Elementor Widget', 'arrigo' ),
					_x( 'in the live editor.', 'Elementor Widget', 'arrigo' ),
					_x( 'The line below an underlined word will not appear on frontend.', 'Elementor Widget', 'arrigo' )
				),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => _x( 'Edit heading...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Subheading
		 */
		$this->add_control(
			'subheading',
			array(
				'label'       => _x( 'Subheading', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Button
		 */
		$this->start_controls_section(
			'button_section',
			array(
				'label' => _x( 'Button', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Button Title
		 */
		$this->add_control(
			'button_title',
			array(
				'label'       => _x( 'Title', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => _x( 'Button', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Button URL
		 */
		$this->add_control(
			'button_link',
			array(
				'label'         => _x( 'Link', 'Elementor Widget', 'arrigo' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'placeholder'   => _x( 'https://...', 'Elementor Widget', 'arrigo' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		/**
		 * Button Style
		 */
		$this->add_control(
			'button_style',
			array(
				'label'       => _x( 'Style', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'button_bordered' => _x( 'Bordered', 'Elementor Widget', 'arrigo' ),
					'button_solid'    => _x( 'Solid', 'Elementor Widget', 'arrigo' ),
				),
				'default'     => 'button_solid',
			)
		);

		/**
		 * Button Color
		 */
		$this->add_control(
			'button_color',
			array(
				'label'       => _x( 'Color', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'button_accent' => _x( 'Accent', 'Elementor Widget', 'arrigo' ),
					'button_dark'   => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
					'button_light'  => _x( 'Light', 'Elementor Widget', 'arrigo' ),
					'button_black'  => _x( 'Black', 'Elementor Widget', 'arrigo' ),
					'button_white'  => _x( 'White', 'Elementor Widget', 'arrigo' ),
				),
				'default'     => 'button_accent',
			)
		);

		$this->end_controls_section();

		/**
		 * Style
		 */
		$this->start_controls_section(
			'style_section',
			array(
				'label' => _x( 'Style', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * Height
		 */
		$this->add_control(
			'height',
			array(
				'label'   => _x( 'Height', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default'    => _x( 'Default', 'Elementor Widget', 'arrigo' ),
					'full'       => _x( 'Fit To Screen', 'Elementor Widget', 'arrigo' ),
					'min-height' => _x( 'Min Height', 'Elementor Widget', 'arrigo' ),
				),
			)
		);

		/**
		 * Min Height
		 */
		$this->add_responsive_control(
			'custom_height',
			array(
				'label'      => _x( 'Minimum Height', 'Elementor Widget', 'arrigo' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'default'    => array(
					'size' => 400,
					'unit' => 'px',
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1440,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'size_units' => array( 'px', 'vh' ),
				'selectors'  => array(
					'{{WRAPPER}} .section__inner' => 'min-height: {{SIZE}}{{UNIT}};',
					// '{{WRAPPER}} .section__inner:after' => 'content: ""; min-height: inherit;', // Hack for IE11
				),
				'condition'  => array(
					'height' => array( 'min-height' ),
				),
			)
		);

		/**
		 * Show Decoration Line
		 */
		$this->add_control(
			'show_decoration_line',
			array(
				'label'   => __( 'Show Line Decoration', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no',
			)
		);

		/**
		 * Color Theme
		 */
		$this->add_control(
			'color_theme',
			array(
				'label'       => _x( 'Color Theme', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'section-intro_dark'  => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
					'section-intro_light' => _x( 'Light', 'Elementor Widget', 'arrigo' ),
				),
				'default'     => 'section-intro_dark',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		/**
		 * Force Animation
		 */
		$this->add_control(
			'force_animation',
			array(
				'label'       => _x( 'Force animation trigger', 'Elementor Widget', 'arrigo' ),
				'description' => _x( 'Enable this if the widget is placed as first element on the page and the animation doesn\'t work after page is loaded.', 'Elementor Widget', 'arrigo' ),
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'condition'   => array(
					'enable_animation!' => '',
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'heading' );
		$this->add_inline_editing_attributes( 'subheading' );

		$settings['heading'] = str_replace( '<u>', '<span class="highlight">', $settings['heading'] );
		$settings['heading'] = str_replace( '</u>', '<span class="highlight__bg"></span></span>', $settings['heading'] );

		$this->add_render_attribute( 'section', 'class', array( 'section', 'section-intro', $settings['color_theme'] ) );
		$this->add_render_attribute( 'section_inner', 'class', array( 'section__inner' ) );

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
			if ( $settings['force_animation'] ) {
				$this->add_render_attribute( 'section', 'data-os-animation', 'force' );
			}
		}

		if ( $settings['height'] == 'default' ) {
			$this->add_render_attribute( 'section', 'class', array( 'section_pt', 'section_pb' ) );
		}

		if ( $settings['height'] == 'full' || $settings['height'] == 'min-height' ) {
			$this->add_render_attribute( 'section', 'class', array( 'section-fullheight' ) );
			$this->add_render_attribute( 'section_inner', 'class', array( 'section-fullheight__inner' ) );
		}
		?>
		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div <?php $this->print_render_attribute_string( 'section_inner' ); ?>>
				<div class="container">
					<div class="row">
						<div class="col-12">
							<?php if ( ! empty( $settings['subheading'] ) ) : ?>
								<div class="section-intro__subheading">
									<span <?php $this->print_render_attribute_string( 'subheading' ); ?>><?php echo $settings['subheading']; ?></span>
								</div>
							<?php endif; ?>
							<?php if ( ! empty( $settings['heading'] ) ) : ?>
								<h1 <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $settings['heading']; ?></h1>
							<?php endif; ?>
							<?php if ( ! empty( $settings['button_title'] ) ) : ?>
								<div class="section-intro__wrapper-button">
									<?php
										$this->add_render_attribute(
											'button',
											array(
												'class' => array( 'button', $settings['button_style'], $settings['button_color'] ),
												'href'  => $settings['button_link']['url'],
											)
										);

									if ( $settings['button_link']['is_external'] ) {
										$this->add_render_attribute( 'button', 'target', '_blank' );
									}

									if ( $settings['button_link']['nofollow'] ) {
										$this->add_render_attribute( 'button', 'rel', 'nofollow' );
									}
									?>
									<a <?php $this->print_render_attribute_string( 'button' ); ?>><span <?php $this->print_render_attribute_string( 'button_title' ); ?>><?php echo $settings['button_title']; ?></span></a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
			<?php if ( $settings['show_decoration_line'] ) : ?>
				<div class="section-intro__line"></div>
			<?php endif; ?>
		</div>
		<?php
	}

	protected function content_template() {
		?>
		<#
			view.addInlineEditingAttributes( 'heading' );
			view.addInlineEditingAttributes( 'subheading' );
			view.addRenderAttribute( 'section', 'class', [ 'section', 'section-intro', settings.color_theme ] );
			view.addRenderAttribute( 'section_inner', 'class', [ 'section__inner' ] );

			if (settings.height == 'default') {
				view.addRenderAttribute( 'section', 'class', [ 'section_pt', 'section_pb' ] );
			}

			if (settings.height == 'full' || settings.height == 'min-height') {
				view.addRenderAttribute( 'section', 'class', [ 'section-fullheight' ] );
				view.addRenderAttribute( 'section_inner', 'class', [ 'section-fullheight__inner' ] );	
			}
		#>
		<div {{{ view.getRenderAttributeString( 'section' ) }}}>
			<div {{{ view.getRenderAttributeString( 'section_inner' ) }}}>
				<div class="container">
					<div class="row">
						<div class="col-12">
							<# if (settings.subheading) { #>
								<div class="section-intro__subheading">
									<span {{{ view.getRenderAttributeString( 'subheading' ) }}}>{{{ settings.subheading }}}</span>
								</div>
							<# } #>
							<# if (settings.heading) { #>
								<h1 {{{ view.getRenderAttributeString( 'heading' ) }}}>
									<#
										if (settings.enable_animation) {
											settings.heading = settings.heading.replace(/\<u\>/g, '<span class="highlight">');
											settings.heading = settings.heading.replace(/<\/u\>/g, '<span class="highlight__bg"></span></span>');
										}
									#>
									{{{ settings.heading }}}
								</h1>
							<# } #>
							<# if (settings.button_title) { #>
								<#
									view.addRenderAttribute(
										'button', {
											'class': [ 'button', settings.button_style, settings.button_color ],
											'href': settings.button_link.url,
										}
									);

									if ( settings.button_link.is_external ) {
										view.addRenderAttribute( 'button', 'target', '_blank' );
									}

									if ( settings.button_link.nofollow ) {
										view.addRenderAttribute( 'button', 'rel', 'nofollow' );
									}
								#>
								<div class="section-intro__wrapper-button">
									<a {{{ view.getRenderAttributeString( 'button' ) }}}><span {{{ view.getRenderAttributeString( 'button_title' ) }}}>{{{ settings.button_title }}}</span></a>
								</div>
							<# } #>
						</div>
					</div>
				</div>
			</div>
			<# if (settings.show_decoration_line) { #>
				<div class="section-intro__line"></div>
			<# } #>
		</div>
		<?php
	}
}
