<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Logo_Client_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-logo-client';
	}

	public function get_title() {
		return _x( 'Logo Client', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Image Src
		 */
		$this->add_control(
			'image',
			array(
				'label'   => _x( 'Choose Image', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="logo-client">
			<img src="<?php echo $settings['image']['url']; ?>" alt=""/>
		</div>
		<?php
	}

	protected function content_template() {
		?>
		<div class="logo-client">
			<img src="{{{ settings.image.url }}}" alt=""/>
		</div>
		<?php
	}
}
