<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Header_Section_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-header-section';
	}

	public function get_title() {
		return _x( 'Header Section', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'heading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Heading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'AREA',
				),
				array(
					'field'       => 'subheading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Subheading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'footer',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Footer', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Heading
		 */
		$this->add_control(
			'heading',
			array(
				'label'       => _x( 'Heading', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
			)
		);

		/**
		 * Subheading
		 */
		$this->add_control(
			'subheading',
			array(
				'label'       => _x( 'Subheading', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		/**
		 * Footer
		 */
		$this->add_control(
			'footer',
			array(
				'label'       => _x( 'Footer', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Style
		 */
		$this->start_controls_section(
			'style_section',
			array(
				'label' => _x( 'Style', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * Inverse Text Color
		 */
		$this->add_control(
			'inverse_text_color',
			array(
				'label'        => _x( 'Inverse Text Color', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'color-white',
			)
		);

		/**
		 * Show Decoration Square
		 */
		$this->add_control(
			'show_decoration_square',
			array(
				'label'   => __( 'Show Square Decoration', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Show Decoration Line
		 */
		$this->add_control(
			'show_decoration_line',
			array(
				'label' => __( 'Show Line Decoration', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::SWITCHER,
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'heading' );
		$this->add_inline_editing_attributes( 'subheading' );
		$this->add_inline_editing_attributes( 'footer' );

		$this->add_render_attribute( 'section', 'class', 'section-header' );

		if ( $settings['inverse_text_color'] ) {
			$this->add_render_attribute( 'section', 'class', $settings['inverse_text_color'] );
		}

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
		}
		?>
		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<?php if ( ! empty( $settings['subheading'] ) ) : ?>
				<div class="section-header__label">
					<?php if ( ! empty( $settings['show_decoration_square'] ) ) : ?>
						<div class="section-header__square"></div>
					<?php endif; ?>
					<span <?php $this->print_render_attribute_string( 'subheading' ); ?>><?php echo $settings['subheading']; ?></span>
				</div>
			<?php endif; ?>
			<?php if ( ! empty( $settings['heading'] ) ) : ?>
				<h2 <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $settings['heading']; ?></h2>
			<?php endif; ?>
			<?php if ( ! empty( $settings['footer'] ) ) : ?>
				<div class="section-header__quote-author">
					<?php if ( ! empty( $settings['show_decoration_line'] ) ) : ?>
						<div class="section-header__quote-line"></div>
					<?php endif; ?>
					<span <?php $this->print_render_attribute_string( 'footer' ); ?>><?php echo $settings['footer']; ?></span>
				</div>
			<?php endif; ?>
			<?php if ( empty( $settings['footer'] ) && ! empty( $settings['show_decoration_line'] ) ) : ?>
				<div class="section-header__line"></div>
			<?php endif; ?>
		</div>
		<?php
	}

	protected function content_template() {
		?>
			<#
				view.addInlineEditingAttributes( 'heading' );
				view.addInlineEditingAttributes( 'subheading' );
				view.addInlineEditingAttributes( 'footer' );

				view.addRenderAttribute( 'section', 'class', 'section-header' );

				if ( settings.inverse_text_color ) {
					view.addRenderAttribute( 'section', 'class', settings.inverse_text_color );
				}
			#>
			<div {{{ view.getRenderAttributeString( 'section' ) }}}>
				<# if (settings.subheading) { #>
					<div class="section-header__label">
						<# if (settings.show_decoration_square) { #>
							<div class="section-header__square"></div>
						<# } #>
						<span {{{ view.getRenderAttributeString( 'subheading' ) }}}>{{{ settings.subheading }}}</span>
					</div>
				<# } #>
				<# if (settings.heading) { #>
					<h2 {{{ view.getRenderAttributeString( 'heading' ) }}}>{{{ settings.heading }}}</h2>
				<# } #>
				<# if (settings.footer) { #>
					<div class="section-header__quote-author">
						<# if (settings.show_decoration_line) { #>
							<div class="section-header__quote-line"></div>
						<# } #>
						<span {{{ view.getRenderAttributeString( 'footer' ) }}}>{{{ settings.footer }}}</span>
					</div>
				<# } #>
				<# if (!settings.footer && settings.show_decoration_line) { #>
					<div class="section-header__line"></div>
				<# } #>
			</div>
		<?php
	}
}
