<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Feature_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-feature';
	}

	public function get_title() {
		return _x( 'Feature', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'title',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Heading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'description',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Subheading', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'AREA',
				),
				'link' => array(
					'field'       => 'link',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Button Link', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINK',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Icon
		 */
		$this->add_control(
			'icon',
			array(
				'label' => _x( 'Icon', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::ICON,
			)
		);

		/**
		 * Title
		 */
		$this->add_control(
			'title',
			array(
				'label'       => _x( 'Title', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		/**
		 * Description
		 */
		$this->add_control(
			'description',
			array(
				'label'       => _x( 'Description', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
			)
		);

		/**
		 * Link
		 */
		$this->add_control(
			'link',
			array(
				'label'         => _x( 'Link', 'Elementor Widget', 'arrigo' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'placeholder'   => _x( 'https://...', 'Elementor Widget', 'arrigo' ),
				'show_external' => true,
				'default'       => array(
					'is_external' => false,
					'nofollow'    => false,
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'icon' );
		$this->add_inline_editing_attributes( 'title' );
		$this->add_inline_editing_attributes( 'description' );

		$tag = 'div';

		$this->add_render_attribute( 'item', 'class', 'figure-feature' );

		if ( ! empty( $settings['link']['url'] ) ) {

			$tag = 'a';

			$this->add_render_attribute( 'item', 'href', $settings['link']['url'] );

			if ( $settings['link']['is_external'] ) {
				$this->add_render_attribute( 'item', 'target', '_blank' );
			}

			if ( $settings['link']['nofollow'] ) {
				$this->add_render_attribute( 'item', 'rel', 'nofollow' );
			}
		}

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'item', 'data-os-animation', 'true' );
		}
		?>
			<<?php echo $tag; ?> <?php $this->print_render_attribute_string( 'item' ); ?>>
				<?php if ( ! empty( $settings['icon'] ) ) : ?>
					<div class="figure-feature__icon">
						<div class="figure-feature__icon-symbol <?php echo $settings['icon']; ?>"></div>
						<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
							<g fill="none" fill-rule="evenodd">
								<g transform="translate(-134.000000, -98.000000)">
									<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
								</g>
							</g>
						</svg>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $settings['title'] ) || ! empty( $settings['description'] ) ) : ?>
					<div class="figure-feature__header">
						<div class="figure-feature__headline"></div>
						<?php if ( ! empty( $settings['title'] ) ) : ?>
							<h3 <?php $this->print_render_attribute_string( 'title' ); ?>><?php echo $settings['title']; ?></h3>
						<?php endif; ?>
						<?php if ( ! empty( $settings['description'] ) ) : ?>
							<p <?php $this->print_render_attribute_string( 'description' ); ?>><?php echo $settings['description']; ?></p>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</<?php echo $tag; ?>>
		<?php
	}

	protected function content_template() {
		?>
		<#

		view.addInlineEditingAttributes( 'icon' );
		view.addInlineEditingAttributes( 'title' );
		view.addInlineEditingAttributes( 'description' );

		var tag = 'div';

		view.addRenderAttribute( 'item', 'class', 'figure-feature' );

		if ( settings.link.url ) {
			tag = 'a';

			view.addRenderAttribute( 'item', 'href', settings.link.url );

			if ( settings.link.is_external ) {
				view.addRenderAttribute( 'item', 'target', '_blank' );
			}

			if ( settings.link.nofollow ) {
				view.addRenderAttribute( 'item', 'rel', 'nofollow' );
			}
		}

		#>
			<{{{ tag }}} {{{ view.getRenderAttributeString( 'item' ) }}}>
				<# if ( settings.icon ) { #>
					<div class="figure-feature__icon">
						<div class="figure-feature__icon-symbol {{{ settings.icon }}}"></div>
						<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
							<g fill="none" fill-rule="evenodd">
								<g transform="translate(-134.000000, -98.000000)">
									<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
								</g>
							</g>
						</svg>
					</div>
				<# } #>
				<# if ( settings.title || settings.description ) { #>
					<div class="figure-feature__header">
						<div class="figure-feature__headline"></div>
						<# if ( settings.title ) { #>
							<h3 {{{ view.getRenderAttributeString( 'title' ) }}}>{{{ settings.title }}}</h3>
						<# } #>
						<# if ( settings.description ) { #>
							<p {{{ view.getRenderAttributeString( 'description' ) }}}>{{{ settings.description }}}</p>
						<# } #>
					</div>
				<# } #>
			</{{{ tag }}}>
		<?php
	}
}
