<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Contact_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-contact';
	}

	public function get_title() {
		return _x( 'Contact', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'text',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Info', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'AREA',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Icon
		 */
		$this->add_control(
			'icon',
			array(
				'label' => _x( 'Icon', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::ICON,
			)
		);

		/**
		 * Text
		 */
		$this->add_control(
			'text',
			array(
				'label' => _x( 'Contact Info', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::TEXTAREA,
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_inline_editing_attributes( 'text' );
		?>

		<div class="figure-contact">
			<?php if ( ! empty( $settings['icon'] ) ) : ?>
				<div class="figure-contact__icon <?php echo $settings['icon']; ?>"></div>
			<?php endif; ?>
			<?php if ( $settings['text'] ) : ?>
				<div class="figure-contact__item">
					<span <?php $this->print_render_attribute_string( 'text' ); ?>><?php echo $settings['text']; ?></span>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}

	protected function content_template() {
		?>
		<#
			view.addInlineEditingAttributes( 'text' );
		#>
		<div class="figure-contact">
			<# if (settings.icon) { #>
				<div class="figure-contact__icon {{{ settings.icon }}}"></div>
			<# } #>
			<# if (settings.text) { #>
				<div class="figure-contact__item">
					<span {{{ view.getRenderAttributeString( 'text' ) }}}>{{{ settings.text }}}</span>
				</div>
			<# } #>
		</div>
		<?php
	}
}
