<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Services_Slider_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'arr_services';

	public function get_name() {
		return 'arrigo-widget-services-slider';
	}

	public function get_title() {
		return _x( 'Services Slider', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	public function get_style_depends() {
		return array( 'swiper' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_controls_posts_toggles( array( 'icon', 'counter' ) );
		$this->add_control(
			'enable_links',
			array(
				'label'   => _x( 'Enable Links to Posts', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Slider
		 */
		$this->start_controls_section(
			'slider_section',
			array(
				'label' => _x( 'Slider', 'Elementor Widget', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Slides Per Screen
		 */
		$this->add_responsive_control(
			'slides_per_view',
			array(
				'label'              => _x( 'Slides Per Screen', 'Elementor Widget', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SLIDER,
				'range'              => array(
					'number' => array(
						'min'  => 1,
						'max'  => 4,
						'step' => 1,
					),
				),
				'devices'            => array( 'desktop', 'tablet', 'mobile' ),
				'default'            => array(
					'size' => 4,
					'unit' => 'number',
				),
				'desktop_default'    => array(
					'size' => 4,
					'unit' => 'number',
				),
				'tablet_default'     => array(
					'size' => 2,
					'unit' => 'number',
				),
				'mobile_default'     => array(
					'size' => 1,
					'unit' => 'number',
				),
				'frontend_available' => true,
			)
		);

		/**
		 * Centered Slides
		 */
		$this->add_responsive_control(
			'centered_slides',
			array(
				'label'              => _x( 'Centered Slides', 'Elementor Widget', 'arrigo' ),
				'label_block'        => true,
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'frontend_available' => true,
			)
		);

		/**
		 * Space Between Slides
		 */
		$this->add_responsive_control(
			'space_between',
			array(
				'label'              => _x( 'Space Between Slides', 'Elementor Widget', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SLIDER,
				'range'              => array(
					'px' => array(
						'min'  => 0,
						'max'  => 160,
						'step' => 1,
					),
				),
				'devices'            => array( 'desktop', 'tablet', 'mobile' ),
				'default'            => array(
					'size' => 0,
					'unit' => 'px',
				),
				'desktop_default'    => array(
					'size' => 0,
					'unit' => 'px',
				),
				'tablet_default'     => array(
					'size' => 0,
					'unit' => 'px',
				),
				'mobile_default'     => array(
					'size' => 0,
					'unit' => 'px',
				),
				'frontend_available' => true,
			)
		);

		/**
		 * Navigation
		 */
		$this->add_control(
			'enable_navigation',
			array(
				'label'   => _x( 'Enable Navigation Arrows', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Progress Bar
		 */
		$this->add_control(
			'enable_progress',
			array(
				'label'   => _x( 'Enable Progress Bar', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay
		 */
		$this->add_control(
			'enable_autoplay',
			array(
				'label'   => _x( 'Autoplay', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay Delay
		 */
		$this->add_control(
			'autoplay_delay',
			array(
				'label'     => _x( 'Autoplay Delay (ms)', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 1000,
						'max'  => 60000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 6000,
				),
				'condition' => array(
					'enable_autoplay' => 'yes',
				),
			)
		);

		/**
		 * Speed
		 */
		$this->add_control(
			'speed',
			array(
				'label'   => _x( 'Speed', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'ms' => array(
						'min'  => 100,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default' => array(
					'unit' => 'ms',
					'size' => 800,
				),
			)
		);

		/**
		 * Direction
		 */
		$this->add_control(
			'direction',
			array(
				'label'   => _x( 'Direction', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'ltr',
				'options' => array(
					'ltr' => array(
						'title' => _x( 'Left to Right', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-chevron-double-right',
					),
					'rtl' => array(
						'title' => _x( 'Right to Left', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-chevron-double-left',
					),
				),
				'toggle'  => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		}

		$classRow   = 'justify-content-between';
		$tagService = 'div';

		if ( ( $settings['enable_navigation'] && ! $settings['enable_progress'] ) || ( ! $settings['enable_navigation'] && $settings['enable_progress'] ) ) {
			$classRow = 'justify-content-center';
		}

		$this->add_render_attribute(
			'swiper',
			array(
				'class'                => array(
					'swiper',
					'swiper-container',
					'swiper-container-initialized',
					'slider',
					'slider-services',
					'js-slider-services',
				),
				'data-speed'           => $settings['speed']['size'],
				'dir'                  => $settings['direction'],
				'data-slides-per-view' => $settings['slides_per_view']['size'],
				'data-space-between'   => $settings['space_between']['size'],
				'data-centered-slides' => $settings['centered_slides'] ? 'true' : 'false',
			)
		);

		if ( array_key_exists( 'slides_per_view_tablet', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-slides-per-view-tablet', $settings['slides_per_view_tablet']['size'] );
		}

		if ( array_key_exists( 'slides_per_view_mobile', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-slides-per-view-mobile', $settings['slides_per_view_mobile']['size'] );
		}

		if ( array_key_exists( 'space_between_tablet', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-space-between-tablet', $settings['space_between_tablet']['size'] );
		}

		if ( array_key_exists( 'space_between_mobile', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-space-between-mobile', $settings['space_between_mobile']['size'] );
		}

		if ( array_key_exists( 'centered_slides_tablet', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-centered-slides-tablet', $settings['centered_slides_tablet'] ? 'true' : 'false' );
		}

		if ( array_key_exists( 'centered_slides_mobile', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-centered-slides-mobile', $settings['centered_slides_mobile'] ? 'true' : 'false' );
		}

		if ( $settings['enable_autoplay'] ) {
			$this->add_render_attribute(
				'swiper',
				array(
					'data-autoplay-enabled' => 'true',
					'data-autoplay-delay'   => is_array( $settings['autoplay_delay'] ) ? $settings['autoplay_delay']['size'] : 0,
				)
			);
		}

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'swiper', 'data-os-animation' );
		}

		if ( $settings['enable_links'] ) {
			$tagService = 'a';
		}

		?>
		<div <?php $this->print_render_attribute_string( 'swiper' ); ?>>
			<div class="swiper-wrapper">
				<?php foreach ( $posts as $item ) : ?>
					<?php
						$post_id = $item['id'];
						$icon    = $settings[ 'icon' . $post_id ];
						$counter = $settings[ 'counter' . $post_id ];

						$this->add_render_attribute(
							'linkAtts',
							array(
								'class' => 'figure-service',
							),
							true,
							true
						);

					if ( $settings['enable_links'] ) {
						$this->add_render_attribute(
							'linkAtts',
							array(
								'class' => 'figure-service',
								'href'  => $item['permalink'],
							),
							true,
							true
						);
					}
					?>
						<div class="swiper-slide slider-services__slide">
							<<?php echo $tagService; ?> <?php $this->print_render_attribute_string( 'linkAtts' ); ?>>
								<header class="figure-service__header">
									<div class="figure-service__headline"></div>
									<?php if ( ! empty( $item['title'] ) ) : ?>
										<h3><?php echo $item['title']; ?></h3>
									<?php endif; ?>
									<?php if ( ! empty( $item['description'] ) ) : ?>
										<p><?php echo $item['description']; ?></p>
									<?php endif; ?>
								</header>
								<?php if ( ! empty( $icon ) ) : ?>
									<div class="figure-service__icon">
										<div class="figure-service__icon-symbol <?php echo $icon; ?>"></div>
										<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
											<g fill="none" fill-rule="evenodd">
												<g transform="translate(-134.000000, -98.000000)">
													<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
												</g>
											</g>
										</svg>
									</div>
								<?php endif; ?>
								<?php if ( ! empty( $counter ) ) : ?>
									<div class="figure-service__number"><?php echo $counter; ?></div>
								<?php endif; ?>
							</<?php echo $tagService; ?>>
						</div>
					<?php endforeach; ?>
			</div>
			<?php if ( $settings['enable_navigation'] || $settings['enable_progress'] ) : ?>
				<div class="container">
					<div class="row align-items-center <?php echo $classRow; ?>">
						<?php if ( $settings['enable_navigation'] ) : ?>
							<!-- naivgation -->
							<div class="col-auto">
								<div class="slider__arrows slider-services__arrows">
									<div class="slider__arrow js-slider-services__arrow-left eicon-angle-left"></div>
									<div class="slider__arrow js-slider-services__arrow-right eicon-angle-right"></div>
								</div>
							</div>
							<!-- - naivgation -->
						<?php endif; ?>
						<?php if ( $settings['enable_progress'] ) : ?>
							<!-- progress bar -->
							<div class="col-auto">
								<div class="slider__progress">
									<div class="swiper swiper-container swiper-container-initialized slider__counter slider__counter_current js-slider-services-counter-current">
										<div class="swiper-wrapper"></div>
									</div>
									<div class="slider__progressbar js-slider-services-progress">
										<div class="slider__progressbar-fill"></div>
									</div>
									<div class="slider__counter slider__counter_total js-slider-services-counter-total">00</div>
								</div>
							</div>
							<!-- - progress bar -->
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}
}
