<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Services_Grid_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'arr_services';

	public function get_name() {
		return 'arrigo-widget-services-grid';
	}

	public function get_title() {
		return _x( 'Services Grid', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		$posts         = $this->get_posts();
		$post_type     = static::$_post_type;
		$post_type_obj = get_post_type_object( $post_type );

		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		foreach ( $posts as $index => $item ) {
			/**
			 * Heading Item
			 */
			$id = 'heading_item' . $item['id'];
			$this->add_control(
				$id,
				array(
					'raw'        => sprintf(
						'<h3 class="elementor-control-title"><strong>%1$s</strong>&nbsp;&nbsp;<a href="%2$s" target="_blank"><i class="eicon-edit"></i></a></h3>',
						$item['title'],
						admin_url( 'post.php?post=' . $item['id'] . '&action=edit' ),
						esc_html__( 'Edit', 'arrigo' )
					),
					'type'       => \Elementor\Controls_Manager::RAW_HTML,
					'conditions' => array(
						'relation' => 'or',
						'terms'    => array(
							array(
								'name'     => 'posts_amount[size]',
								'operator' => '>',
								'value'    => $index,
							),
							array(
								'name'     => 'posts_amount[size]',
								'operator' => '<=',
								'value'    => '0',
							),
						),
					),
				)
			);

			/**
			 * Toggle
			 */
			$id = 'enabled' . $item['id'];
			$this->add_control(
				$id,
				array(
					'label'      => _x( 'Enabled', 'Elementor Widget', 'arrigo' ),
					'type'       => \Elementor\Controls_Manager::SWITCHER,
					'default'    => 'yes',
					'conditions' => array(
						'relation' => 'or',
						'terms'    => array(
							array(
								'name'     => 'posts_amount[size]',
								'operator' => '>',
								'value'    => $index,
							),
							array(
								'name'     => 'posts_amount[size]',
								'operator' => '<=',
								'value'    => '0',
							),
						),
					),
				)
			);

			/**
			 * Icon
			 */
			$id = 'icon' . $item['id'];
			$this->add_control(
				$id,
				array(
					'label'      => _x( 'Icon', 'Elementor Widget', 'arrigo' ),
					'type'       => \Elementor\Controls_Manager::ICON,
					'conditions' => array(
						'relation' => 'or',
						'terms'    => array(
							array(
								'name'     => 'posts_amount[size]',
								'operator' => '>',
								'value'    => $index,
							),
							array(
								'name'     => 'posts_amount[size]',
								'operator' => '<=',
								'value'    => '0',
							),
						),
					),
					'separator'  => 'after',
				)
			);
		}

		$this->add_control(
			'enable_links',
			array(
				'label'   => _x( 'Enable Links to Posts', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Not Editable Widget Info
		 */
		$this->add_control(
			'dynamic_content_info',
			array(
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => sprintf(
					'%1$s <strong>%2$s.</strong> %3$s<br><br>%4$s <a href="%5$s" target="_blank">%6$s</a>',
					esc_html__( 'This widget displays content dynamically from the existing', 'arrigo' ),
					$post_type_obj->labels->name,
					esc_html__( 'It\'s not editable directly through Elementor Page Builder.', 'arrigo' ),
					esc_html__( 'You can edit or re-order your posts', 'arrigo' ),
					admin_url( 'edit.php?post_type=' . $post_type ),
					esc_html__( 'in WordPress admin panel', 'arrigo' )
				),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Settings
		 */
		$this->start_controls_section(
			'settings_section',
			array(
				'label' => _x( 'Settings', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Number of Posts
		 */
		$this->add_control(
			'posts_amount',
			array(
				'label'   => _x( 'Number of Portfolio Items to Display (0 for all)', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'number' => array(
						'min'  => 0,
						'max'  => 16,
						'step' => 1,
					),
				),
				'default' => array(
					'unit' => 'number',
					'size' => 0,
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		}

		$tagService = 'div';

		$this->add_render_attribute( 'section', 'class', array( 'section', 'section-features' ) );

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
		}

		if ( $settings['enable_links'] ) {
			$tagService = 'a';
		}
		?>
		<?php if ( ! empty( $posts ) ) : ?>
			<div <?php $this->print_render_attribute_string( 'section' ); ?>>
				<div class="container container_25">
					<div class="row">
						<?php foreach ( $posts as $item ) : ?>
							<?php
								$post_id = $item['id'];
								$icon    = $settings[ 'icon' . $post_id ];

								$this->add_render_attribute(
									'linkAtts',
									array(
										'class' => 'figure-feature',
									),
									true,
									true
								);

							if ( $settings['enable_links'] ) {
								$this->add_render_attribute(
									'linkAtts',
									array(
										'class' => 'figure-feature',
										'href'  => $item['permalink'],
									),
									true,
									true
								);
							}
							?>
							<div class="col-lg-4 col-sm-6 section-features__item">
								<<?php echo $tagService; ?> <?php $this->print_render_attribute_string( 'linkAtts' ); ?>>
									<?php if ( ! empty( $icon ) ) : ?>
										<div class="figure-feature__icon">
											<div class="figure-feature__icon-symbol <?php echo $icon; ?>"></div>
											<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
												<g fill="none" fill-rule="evenodd">
													<g transform="translate(-134.000000, -98.000000)">
														<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
													</g>
												</g>
											</svg>
										</div>
									<?php endif; ?>
									<div class="figure-feature__header">
										<div class="figure-feature__headline"></div>
										<?php if ( ! empty( $item['title'] ) ) : ?>
											<h3><?php echo $item['title']; ?></h3>
										<?php endif; ?>
										<?php if ( ! empty( $item['description'] ) ) : ?>
											<p><?php echo $item['description']; ?></p>
										<?php endif; ?>
									</div>
								</<?php echo $tagService; ?>>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<?php
	}
}
