<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Portfolio_Slider_Fullscreen_2_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'arr_portfolio';

	public function get_name() {
		return 'arrigo-widget-portfolio-slider-fullscreen-2';
	}

	public function get_title() {
		return _x( 'Portfolio Slider Fullscreen 2', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	public function get_style_depends() {
		return array( 'swiper' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_controls_posts_toggles();
		$this->end_controls_section();

		/**
		 * Section Social
		 */
		$this->start_controls_section(
			'social_section',
			array(
				'label' => _x( 'Social', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Social Heading
		 */
		$this->add_control(
			'social_heading',
			array(
				'label' => _x( 'Social Media', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		$repeater = new \Elementor\Repeater();

		/**
		 * Social Link
		 */
		$repeater->add_control(
			'social_link',
			array(
				'label'         => _x( 'Link', 'Elementor Widget', 'arrigo' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'placeholder'   => _x( 'https://...', 'Elementor Widget', 'arrigo' ),
				'show_external' => true,
				'default'       => array(
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		/**
		 * Social Icon
		 */
		$repeater->add_control(
			'social_icon',
			array(
				'label' => _x( 'Icon', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::ICON,
			)
		);

		/**
		 * Social Repeater Control
		 */
		$this->add_control(
			'social',
			array(
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ social_icon.replace("fa fa-", "") }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Slider
		 */
		$this->start_controls_section(
			'slider_section',
			array(
				'label' => _x( 'Slider', 'Elementor Widget', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Slides Per Screen
		 */
		$this->add_responsive_control(
			'slides_per_view',
			array(
				'label'              => _x( 'Slides Per Screen', 'Elementor Widget', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SLIDER,
				'range'              => array(
					'number' => array(
						'min'  => 1,
						'max'  => 4,
						'step' => 1,
					),
				),
				'devices'            => array( 'desktop', 'tablet', 'mobile' ),
				'default'            => array(
					'size' => 4,
					'unit' => 'number',
				),
				'desktop_default'    => array(
					'size' => 4,
					'unit' => 'number',
				),
				'tablet_default'     => array(
					'size' => 2,
					'unit' => 'number',
				),
				'mobile_default'     => array(
					'size' => 1,
					'unit' => 'number',
				),
				'frontend_available' => true,
			)
		);

		/**
		 * Navigation
		 */
		$this->add_control(
			'enable_navigation',
			array(
				'label'   => _x( 'Enable Navigation Arrows', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Progress Bar
		 */
		$this->add_control(
			'enable_progress',
			array(
				'label'   => _x( 'Enable Progress Bar', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay
		 */
		$this->add_control(
			'enable_autoplay',
			array(
				'label'   => _x( 'Autoplay', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay Delay
		 */
		$this->add_control(
			'autoplay_delay',
			array(
				'label'     => _x( 'Autoplay Delay (ms)', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 1000,
						'max'  => 60000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 6000,
				),
				'condition' => array(
					'enable_autoplay' => 'yes',
				),
			)
		);

		/**
		 * Speed
		 */
		$this->add_control(
			'speed',
			array(
				'label'   => _x( 'Speed', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'ms' => array(
						'min'  => 100,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default' => array(
					'unit' => 'ms',
					'size' => 800,
				),
			)
		);

		/**
		 * Direction
		 */
		$this->add_control(
			'direction',
			array(
				'label'   => _x( 'Direction', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'ltr',
				'options' => array(
					'ltr' => array(
						'title' => _x( 'Left to Right', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-chevron-double-right',
					),
					'rtl' => array(
						'title' => _x( 'Right to Left', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-chevron-double-left',
					),
				),
				'toggle'  => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Settings
		 */
		$this->start_controls_section(
			'settings_section',
			array(
				'label' => _x( 'Settings', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Show Categories
		 */
		$this->add_control(
			'show_categories',
			array(
				'label'   => _x( 'Show Categories', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => '',
			)
		);

		/**
		 * Show Description
		 */
		$this->add_control(
			'show_description',
			array(
				'label'   => _x( 'Show Short Description', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => '',
			)
		);

		/**
		 * Show Description
		 */
		$this->add_control(
			'show_headline',
			array(
				'label'   => _x( 'Show Headline', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Style
		 */
		$this->start_controls_section(
			'style_section',
			array(
				'label' => _x( 'Style', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * Color Theme
		 */
		$this->add_control(
			'color_theme',
			array(
				'label'   => _x( 'Color Theme', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => array(
					'slider-fullscreen4_dark'  => array(
						'title' => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-circle',
					),
					'slider-fullscreen4_light' => array(
						'title' => _x( 'Light', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-circle-o',
					),
				),
				'default' => 'slider-fullscreen4_light',
				'toggle'  => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		}

		$this->add_render_attribute(
			'section',
			'class',
			array(
				'section',
				'section-fullscreen',
				'section-fullscreen_4',
			)
		);

		$this->add_render_attribute(
			'swiper',
			array(
				'class'                => array(
					'swiper',
					'swiper-container',
					'swiper-container-initialized',
					'slider-fullscreen4',
					'js-slider-fullscreen4',
					$settings['color_theme'],
				),
				'data-speed'           => $settings['speed']['size'],
				'dir'                  => $settings['direction'],
				'data-slides-per-view' => $settings['slides_per_view']['size'],
			)
		);

		if ( array_key_exists( 'slides_per_view_tablet', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-slides-per-view-tablet', $settings['slides_per_view_tablet']['size'] );
		}

		if ( array_key_exists( 'slides_per_view_mobile', $settings ) ) {
			$this->add_render_attribute( 'swiper', 'data-slides-per-view-mobile', $settings['slides_per_view_mobile']['size'] );
		}

		if ( $settings['enable_autoplay'] ) {
			$this->add_render_attribute(
				'swiper',
				array(
					'data-autoplay-enabled' => 'true',
					'data-autoplay-delay'   => $settings['autoplay_delay']['size'],
				)
			);
		}

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
		}
		?>
		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div <?php $this->print_render_attribute_string( 'swiper' ); ?>>
				<div class="swiper-wrapper">
					<?php foreach ( $posts as $item ) : ?>
						<div class="swiper-slide">
							<div class="slider-fullscreen4__slide-wrapper-bg">
								<?php if ( ! empty( $item['title'] ) ) : ?>
									<header class="slider-fullscreen4__slide-header">
										<?php if ( $settings['show_headline'] ) : ?>
											<div class="slider-fullscreen4__slide-headline"></div>
										<?php endif; ?>
										<?php if ( $settings['show_categories'] && ! empty( $item['categories'] ) ) : ?>
											<div class="slider__wrapper-categories">
												<ul class="post-meta">
													<?php foreach ( $item['categories'] as $category ) : ?>
														<li><?php echo esc_html( $category->name ); ?></li>
													<?php endforeach; ?>
												</ul>
											</div>
										<?php endif; ?>
										<h2><?php echo $item['title']; ?></h2>
										<?php if ( $settings['show_description'] && ! empty( $item['description'] ) ) : ?>
											<p><?php echo $item['description']; ?></p>
										<?php endif; ?>
									</header>
								<?php endif; ?>
								<a class="slider-fullscreen4__slide-button button-square" href="<?php echo $item['permalink']; ?>">
									<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
										<g fill="none" fill-rule="evenodd">
											<rect class="rect" width="100%" height="100%"></rect>
										</g>
									</svg>
									<i class="lnr lnr-arrow-right"></i>
								</a>
								<?php
									arr_the_lazy_image(
										array(
											'id'    => $item['image_id'],
											'type'  => 'image',
											'class' => array(
												'wrapper' => false,
												'image'   => array( 'swiper-lazy', 'slider-fullscreen4__slide-bg', 'of-cover' ),
											),
										)
									);
								?>
								<div class="slider-fullscreen4__slide-overlay overlay"></div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
			<?php if ( $settings['enable_navigation'] || $settings['enable_progress'] || $settings['social'] ) : ?>
				<div class="section-fullscreen__footer container-fluid">
					<div class="row align-items-center justify-content-center">
						<div class="col-lg-4 text-left">
							<?php if ( $settings['enable_navigation'] ) : ?>
								<div class="slider__arrows slider-fullscreen4__arrows">
									<div class="slider__arrow js-slider-fullscreen4-arrow-left eicon-angle-left"></div>
									<div class="slider__arrow js-slider-fullscreen4-arrow-right eicon-angle-right"></div>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-lg-4 text-center">
							<?php if ( $settings['enable_progress'] ) : ?>
								<div class="slider__progress slider-fullscreen4__progress">
									<div class="swiper swiper-container swiper-container-initialized slider__counter slider__counter_current js-slider-fullscreen4-counter-current">
										<div class="swiper-wrapper"></div>
									</div>
									<div class="slider__progressbar js-slider-fullscreen4-progress">
										<div class="slider__progressbar-fill"></div>
									</div>
									<div class="slider__counter slider__counter_total js-slider-fullscreen4-counter-total">00</div>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-lg-4 text-right">
							<?php if ( $settings['social'] ) : ?>
								<div class="slider-fullscreen4__social">
									<ul class="social">
										<?php foreach ( $settings['social'] as $item ) : ?>
											<li class="social__item">
												<?php
													$target   = $item['social_link']['is_external'] ? ' target="_blank"' : '';
													$nofollow = $item['social_link']['nofollow'] ? ' rel="nofollow"' : '';
												?>
												<a class="<?php echo $item['social_icon']; ?>" href="<?php echo $item['social_link']['url']; ?>" <?php echo $target . ' ' . $nofollow; ?>>
													<svg viewBox="0 0 152 152" version="1.1"
														xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
														<g fill="none" fill-rule="evenodd">
															<g transform="translate(-134.000000, -98.000000)">
																<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
															</g>
														</g>
													</svg>
												</a>
											</li>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}
}
