<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Portfolio_Slider_Fullscreen_1_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'arr_portfolio';

	public function get_name() {
		return 'arrigo-widget-portfolio-slider-fullscreen-1';
	}

	public function get_title() {
		return _x( 'Portfolio Slider Fullscreen 1', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	public function get_style_depends() {
		return array( 'swiper' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_controls_posts_toggles();
		$this->end_controls_section();

		/**
		 * Section Slider
		 */
		$this->start_controls_section(
			'slider_section',
			array(
				'label' => _x( 'Slider', 'Elementor Widget', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Navigation
		 */
		$this->add_control(
			'enable_navigation',
			array(
				'label'   => _x( 'Enable Navigation Arrows', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Dots
		 */
		$this->add_control(
			'enable_dots',
			array(
				'label'   => _x( 'Enable Dots', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Counter
		 */
		$this->add_control(
			'enable_counter',
			array(
				'label'   => _x( 'Enable Counter', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay
		 */
		$this->add_control(
			'enable_autoplay',
			array(
				'label'   => _x( 'Autoplay', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay Delay
		 */
		$this->add_control(
			'autoplay_delay',
			array(
				'label'     => _x( 'Autoplay Delay (ms)', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 1000,
						'max'  => 60000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 6000,
				),
				'condition' => array(
					'enable_autoplay' => 'yes',
				),
			)
		);

		/**
		 * Speed
		 */
		$this->add_control(
			'speed',
			array(
				'label'   => _x( 'Speed', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'ms' => array(
						'min'  => 100,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default' => array(
					'unit' => 'ms',
					'size' => 800,
				),
			)
		);

		/**
		 * Overlap Factor
		 */
		$this->add_control(
			'overlap_factor',
			array(
				'label'       => _x( 'Overlap Factor', 'Elementor Widget', 'arrigo' ),
				'description' => _x( 'Defines enter-leave slides transition effect on cover images. Set "0" to disable.', 'Elementor Widget', 'arrigo' ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'range'       => array(
					'ms' => array(
						'min'  => 0,
						'max'  => 1,
						'step' => 0.01,
					),
				),
				'default'     => array(
					'unit' => 'ms',
					'size' => 0.5,
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Section Settings
		 */
		$this->start_controls_section(
			'settings_section',
			array(
				'label' => _x( 'Settings', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Show Categories
		 */
		$this->add_control(
			'show_categories',
			array(
				'label'   => _x( 'Show Categories', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => '',
			)
		);

		/**
		 * Show Description
		 */
		$this->add_control(
			'show_description',
			array(
				'label'   => _x( 'Show Short Description', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		}

		$this->add_render_attribute(
			'section',
			'class',
			array(
				'section',
				'section-fullscreen',
				'section-fullscreen_1',
			)
		);

		$this->add_render_attribute(
			'swiper',
			array(
				'class'               => array(
					'swiper',
					'swiper-container',
					'swiper-container-initialized',
					'slider-fullscreen-img',
					'js-slider-fullscreen__slider-img',
				),
				'data-speed'          => is_array( $settings['speed'] ) ? $settings['speed']['size'] : 0,
				'data-overlap-factor' => is_array( $settings['overlap_factor'] ) ? $settings['overlap_factor']['size'] : 0,
			)
		);

		$this->add_render_attribute( 'wrapper_counter', 'class', 'slider-fullscreen__wrapper-counter' );

		if ( ! $settings['enable_counter'] ) {
			$this->add_render_attribute( 'wrapper_counter', 'class', 'hidden' );
		}

		if ( $settings['enable_autoplay'] ) {
			$this->add_render_attribute(
				'swiper',
				array(
					'data-autoplay-enabled' => 'true',
					'data-autoplay-delay'   => is_array( $settings['autoplay_delay'] ) ? $settings['autoplay_delay']['size'] : 0,
				)
			);
		}

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
		}
		?>
		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div class="slider-fullscreen slider js-slider-fullscreen">
				<?php if ( $settings['enable_dots'] ) : ?>
					<div class="slider-fullscreen__wrapper-controls">
						<div class="slider__controls slider-fullscreen__controls">
							<div class="slider__dots js-slider-fullscreen__dots">
								<div class="slider__dot slider__dot_active"></div>
								<div class="slider__dot"></div>
								<div class="slider__dot"></div>
								<div class="slider__dot"></div>
							</div>
						</div>
					</div>
					<!-- - slider controls -->
				<?php endif; ?>
				<?php if ( $settings['enable_navigation'] ) : ?>
					<div class="slider__arrows slider-fullscreen__arrows">
						<div class="slider__arrow slider-fullscreen__arrow js-slider-fullscreen-arrow-left eicon-angle-left"></div>
						<div class="slider__arrow slider-fullscreen__arrow js-slider-fullscreen-arrow-right eicon-angle-right"></div>
					</div>
					<!-- - slider arrows -->
				<?php endif; ?>
				<div class="slider-fullscreen__wrapper-img overflow">
					<?php if ( $settings['enable_animation'] ) : ?>
						<div class="overflow__curtain bg-accent"></div>
					<?php endif; ?>
					<div class="overflow__content">
						<div <?php $this->print_render_attribute_string( 'swiper' ); ?>>
							<div class="swiper-wrapper">
								<?php foreach ( $posts as $item ) : ?>
									<div class="swiper-slide slider-fullscreen__slide">
										<?php
											arr_the_lazy_image(
												array(
													'id'   => $item['image_id'],
													'type' => 'image',
													'class' => array(
														'wrapper' => false,
														'image' => array( 'swiper-lazy', 'slider-fullscreen-img__slide-bg', 'of-cover' ),
													),
												)
											);
										?>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
				<!-- - slider image -->
				<div class="slider-fullscreen__wrapper-content container">
					<div class="row justify-content-xl-end">
						<div class="col-xl-5 col-lg-6">
							<div class="slider-fullscreen__slide-headline"></div>
							<div class="swiper swiper-container swiper-container-initialized slider-fullscreen-content js-slider-fullscreen__slider-content">
								<div class="swiper-wrapper">
									<?php foreach ( $posts as $item ) : ?>
										<div class="swiper-slide">
											<div class="slider-fullscreen__slide-content">
												<header class="slider-fullscreen__slide-header">
													<?php if ( $settings['show_categories'] && ! empty( $item['categories'] ) ) : ?>
														<div class="slider__wrapper-categories">
															<ul class="post-meta">
																<?php foreach ( $item['categories'] as $category ) : ?>
																	<li><?php echo esc_html( $category->name ); ?></li>
																<?php endforeach; ?>
															</ul>
														</div>
													<?php endif; ?>
													<?php if ( ! empty( $item['title'] ) ) : ?>
														<a href="<?php echo $item['permalink']; ?>">
															<h2><?php echo $item['title']; ?></h2>
														</a>
													<?php endif; ?>
													<?php if ( $settings['show_description'] && ! empty( $item['description'] ) ) : ?>
														<p><?php echo $item['description']; ?></p>
													<?php endif; ?>
												</header>
												<div class="slider-fullscreen__slide-wrapper-button">
													<a class="slider-fullscreen__slide-button button-square" href="<?php echo $item['permalink']; ?>">
														<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
															<g fill="none" fill-rule="evenodd">
																<rect class="rect" width="100%" height="100%"></rect>
															</g>
														</svg>
														<i class="lnr lnr-arrow-right"></i>
													</a>
												</div>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!-- - slider content -->
				<div <?php $this->print_render_attribute_string( 'wrapper_counter' ); ?>>
					<div class="slider__counter-big">
						<div class="swiper swiper-container swiper-container-initialized slider__counter-big-current slider-fullscreen__counter-big-current js-slider-fullscreen__counter-current">
							<div class="swiper-wrapper"></div>
						</div>
						<div class="slider__counter-big-total js-slider-fullscreen__counter-total"></div>
					</div>
				</div>
				<!-- - slider counter -->
				<div class="section-fullscreen__backgrounds">
					<div class="section-fullscreen__inner-bg bg-dark"></div>
					<div class="section-fullscreen__inner-bg bg-light"></div>
				</div>
				<!-- slider backgrounds -->
			</div>
		</div>
		<?php
	}
}
