<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Portfolio_Masonry_Grid_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'arr_portfolio';

	public function get_name() {
		return 'arrigo-widget-portfolio-masonry-grid';
	}

	public function get_title() {
		return _x( 'Portfolio Masonry Grid & Gallery', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_controls_posts_toggles();
		$this->end_controls_section();

		/**
		 * Section Settings
		 */
		$this->start_controls_section(
			'settings_section',
			array(
				'label' => _x( 'Settings', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Isotope Filter
		 */
		$this->add_control(
			'enable_filter',
			array(
				'label' => _x( 'Enable Grid Filter', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::SWITCHER,
			)
		);

		/**
		 * Enable Lightbox
		 */
		$this->add_control(
			'lightbox',
			array(
				'label'   => _x( 'Enable Lightbox', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Show Title
		 */
		$this->add_control(
			'show_title',
			array(
				'label'   => _x( 'Show Item Title', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Show Categories
		 */
		$this->add_control(
			'show_categories',
			array(
				'label'     => _x( 'Show Item Categories', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'show_title' => 'yes',
				),
			)
		);

		/**
		 * Show Headline
		 */
		$this->add_control(
			'show_headline',
			array(
				'label'     => _x( 'Show Title Headline', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'show_title' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Section Layout
		 */
		$this->start_controls_section(
			'layout_section',
			array(
				'label' => _x( 'Layout', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_LAYOUT,
			)
		);

		/**
		 * Columns
		 */
		$selector_value_string = 'flex: 0 0 calc({{VALUE}} / 12  * 100%); max-width: calc({{VALUE}} / 12 * 100%);';
		$this->add_responsive_control(
			'columns',
			array(
				'label'              => _x( 'Columns', 'Elementor Widget', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => array(
					3  => _x( 'Four Columns', 'Elementor Widget', 'arrigo' ),
					4  => _x( 'Three Columns', 'Elementor Widget', 'arrigo' ),
					6  => _x( 'Two Columns', 'Elementor Widget', 'arrigo' ),
					12 => _x( 'Single Column', 'Elementor Widget', 'arrigo' ),
				),
				'selectors'          => array(
					'{{WRAPPER}} .grid__sizer' => $selector_value_string,
					'{{WRAPPER}} .grid__item'  => $selector_value_string,
				),
				'render_type'        => 'template',
				'default'            => 4,
				'desktop_default'    => 4,
				'tablet_default'     => 6,
				'mobile_default'     => 12,
				'frontend_available' => true,
			)
		);

		/**
		 * Space Between
		 */
		$this->add_responsive_control(
			'space_between',
			array(
				'label'              => _x( 'Space Between', 'Elementor Widget', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SLIDER,
				'range'              => array(
					'px' => array(
						'min'  => 0,
						'max'  => 120,
						'step' => 1,
					),
				),
				'devices'            => array( 'desktop', 'tablet', 'mobile' ),
				'default'            => array(
					'size' => 80,
					'unit' => 'px',
				),
				'desktop_default'    => array(
					'size' => 80,
					'unit' => 'px',
				),
				'tablet_default'     => array(
					'size' => 30,
					'unit' => 'px',
				),
				'mobile_default'     => array(
					'size' => 15,
					'unit' => 'px',
				),
				'selectors'          => array(
					'{{WRAPPER}} .grid'       => 'margin: calc(-{{SIZE}}{{UNIT}} / 2);',
					'{{WRAPPER}} .grid__item' => 'padding: calc({{SIZE}}{{UNIT}} / 2);',
					'{{WRAPPER}} .filter'     => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		};

		$active_taxonomies      = $settings['enable_filter'] ? $this->get_taxonomies_to_display( $posts ) : array();
		$has_filter             = $settings['enable_filter'] && ! empty( $active_taxonomies['items'] );
		$filterable_item_prefix = 'category-';
		$lightbox               = $settings['lightbox'];

		$columns_desktop = array_key_exists( 'columns', $settings ) ? $settings['columns'] : 12;
		$columns_tablet  = array_key_exists( 'columns_tablet', $settings ) ? $settings['columns_tablet'] : 12;
		$columns_mobile  = array_key_exists( 'columns_mobile', $settings ) ? $settings['columns_mobile'] : 12;

		$col_desktop = 'grid__item_desktop-' . $this->translate_columns_settings_inverse( $columns_desktop );
		$col_tablet  = 'grid__item_tablet-' . $this->translate_columns_settings_inverse( $columns_tablet );
		$col_mobile  = 'grid__item_mobile-' . $this->translate_columns_settings_inverse( $columns_mobile );

		$this->add_render_attribute(
			'section',
			array(
				'class'                    => array( 'grid', 'js-grid' ),
				'data-grid-columns'        => 12 / $this->translate_columns_settings( $columns_desktop ),
				'data-grid-columns-tablet' => 12 / $this->translate_columns_settings( $columns_tablet ),
				'data-grid-columns-mobile' => 12 / $this->translate_columns_settings( $columns_mobile ),
			)
		);

		$this->add_render_attribute(
			'sizerAtts',
			array(
				'class' => array( 'grid__sizer', 'js-grid__sizer', $col_desktop, $col_tablet, $col_mobile ),
			)
		);

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
		}
		?>

		<?php if ( $has_filter ) : ?>
			<div class="filter">
				<ul class="filter__list js-filter">
					<li class="filter__item filter__item_active js-filter__item" data-filter="*"><?php esc_html_e( 'All', 'arrigo' ); ?></li>
					<?php foreach ( $active_taxonomies['items'] as $index => $item ) : ?>
						<?php
							$filter_item_slug       = $item['slug'];
							$filter_item_name       = $item['name'];
							$filter_attribute_value = '.' . $filterable_item_prefix . $filter_item_slug;
						?>
						<li class="filter__item js-filter__item" data-filter="<?php echo esc_attr( $filter_attribute_value ); ?>"><?php echo esc_html( $filter_item_name ); ?></li>
					<?php endforeach; ?>
				</ul>
			</div>
		<?php endif; ?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div <?php $this->print_render_attribute_string( 'sizerAtts' ); ?>></div>
			<?php foreach ( $posts as $index => $item ) : ?>
				<?php
					$categories = array();
				if ( is_array( $item['categories'] ) && ! empty( $item['categories'] ) ) {
					foreach ( $item['categories'] as $taxonomy ) {

						$this->add_render_attribute(
							'itemAtts' . $index,
							array(
								'class' => esc_attr( $filterable_item_prefix . $taxonomy->slug ),
							)
						);
						$categories[] .= $taxonomy->name;
					}
				}

					$this->add_render_attribute(
						'itemAtts' . $index,
						array(
							'class' => array( 'grid__item', 'js-grid__item', $col_desktop, $col_tablet, $col_mobile ),
						)
					);
				?>
				<?php if ( $item['image_url'] ) : ?>
					<div <?php $this->print_render_attribute_string( 'itemAtts' . $index ); ?>>
						<?php
						$this->add_render_attribute(
							'linkAtts',
							array(
								'class' => 'grid__item-link',
								'href'  => $item['permalink'],
							),
							true,
							true
						);

						if ( $lightbox ) {
							$this->add_render_attribute(
								'linkAtts',
								array(
									'href' => $item['image_url'],
									'data-elementor-open-lightbox' => 'true',
									'data-elementor-lightbox-slideshow' => $this->get_id(),
								),
								true,
								true
							);
						}
						?>
						<a <?php $this->print_render_attribute_string( 'linkAtts' ); ?>>
							<div class="grid__item-wrapper-img">
								<?php if ( $lightbox ) : ?>
									<div class="grid__item-icon">
										<div class="grid__item-icon-symbol lnr lnr-magnifier"></div>
										<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
											<g fill="none" fill-rule="evenodd">
												<g transform="translate(-134.000000, -98.000000)">
													<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
												</g>
											</g>
										</svg>
									</div>
									<div class="overlay overlay_dark grid__item-overlay"></div>
								<?php endif; ?>
								<?php
									arr_the_lazy_image(
										array(
											'id'   => $item['image_id'],
											'type' => 'image',
										)
									);
								?>
							</div>
							<?php if ( $settings['show_title'] ) : ?>
								<div class="grid__item-header">
									<?php if ( $settings['show_categories'] && ! empty( $item['categories'] ) ) : ?>
										<ul class="post-meta">
											<?php foreach ( $item['categories'] as $category ) : ?>
												<li><?php echo esc_html( $category->name ); ?></li>
											<?php endforeach; ?>
										</ul>
									<?php endif; ?>
									<h3><?php echo $item['title']; ?></h3>
									<?php if ( $settings['show_headline'] ) : ?>
										<div class="grid__item-headline"></div>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</a>
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
		<?php
	}
}
