<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Portfolio_Grid_Irregular_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'arr_portfolio';

	public function get_name() {
		return 'arrigo-widget-portfolio-grid-irregular';
	}

	public function get_title() {
		return _x( 'Portfolio Grid Irregular', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_controls_posts_toggles( array( 'orientation', 'position' ) );
		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		}
		?>
		<div class="container">
			<?php foreach ( $posts as $item ) : ?>
				<?php
					$post_id           = $item['id'];
					$orientation_class = $settings[ 'orientation' . $post_id ];
					$content_class     = $settings[ 'content' . $post_id ];
					$col_class         = $orientation_class == 'figure-portfolio_horizontal' ? 'col-lg-10' : 'col-lg-5';
					$row_class         = $content_class == 'figure-portfolio_left' ? 'justify-content-start' : 'justify-content-end';

					$this->add_render_attribute(
						$post_id . 'row',
						'class',
						array(
							'row',
							'figure-portfolio',
							$row_class,
							$orientation_class,
							$content_class,
						)
					);

					$this->add_render_attribute(
						$post_id . 'col',
						array(
							'class' => array(
								'figure-portfolio__link',
								'col',
								$col_class,
							),
							'href'  => $item['permalink'],
						)
					);

				if ( $settings['enable_animation'] ) {
					$this->add_render_attribute( $post_id . 'row', 'data-os-animation' );
				}

				?>
				<div class="section-portfolio__wrapper-item">
					<div <?php $this->print_render_attribute_string( $post_id . 'row' ); ?>>
						<a <?php $this->print_render_attribute_string( $post_id . 'col' ); ?>>
							<?php if ( $item['image_id'] ) : ?>
								<div class="figure-portfolio__wrapper-img overflow">
									<?php if ( $settings['enable_animation'] ) : ?>
										<div class="overflow__curtain bg-accent"></div>
										<div class="overflow__content">
											<?php
												arr_the_lazy_image(
													array(
														'id' => $item['image_id'],
													)
												);
											?>
										</div>
									<?php else : ?>
										<?php
											arr_the_lazy_image(
												array(
													'id' => $item['image_id'],
												)
											);
										?>
									<?php endif; ?>
								</div>
							<?php endif; ?>
							<?php if ( ! empty( $item['categories'] ) ) : ?>
							<div class="figure-portfolio__info">
								<?php foreach ( $item['categories'] as $category ) : ?>
									<span><?php echo esc_html( $category->name ); ?></span>
								<?php endforeach; ?>
							</div>
							<?php endif; ?>
							<?php if ( ! empty( $item['title'] ) ) : ?>
								<header class="figure-portfolio__header">
									<div class="figure-portfolio__headline"></div>
									<h2><?php echo $item['title']; ?></h2>
								</header>
							<?php endif; ?>
						</a>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php
	}
}
