<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Latest_Posts_Widget extends Arr_Widget_Base {
	protected static $_instance;
	protected static $_posts;
	protected static $_post_type = 'post';

	public function get_name() {
		return 'arrigo-widget-latest-posts';
	}

	public function get_title() {
		return _x( 'Latest Posts', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'arrigo-dynamic' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_controls_posts_toggles();
		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		if ( empty( $posts ) ) {
			return;
		}
		?>
		<?php foreach ( $posts as $item ) : ?>
			<div class="section-news__wrapper-post">
				<a class="figure-post" href="<?php echo $item['permalink']; ?>" <?php echo $settings['enable_animation']; ?>>
					<?php if ( $item['image_id'] ) : ?>
						<?php
							arr_the_lazy_image(
								array(
									'id'    => $item['image_id'],
									'type'  => 'background',
									'class' => array(
										'wrapper' => array(),
										'image'   => array( 'figure-post__wrapper-img', 'of-cover' ),
									),
								)
							)
						?>
					<?php endif; ?>
					<div class="container">
						<div class="row align-items-center">
						<div class="col-lg-2">
							<?php if ( array_key_exists( 'date', $item ) && ! empty( $item['date'] ) ) : ?>
								<div class="figure-post__date"><?php echo $item['date']; ?></div>
							<?php endif; ?>
						</div>
						<?php if ( ! empty( $item['title'] ) ) : ?>
							<div class="col-lg-8">
								<div class="figure-post__content">
									<h3><?php echo $item['title']; ?></h3>
								</div>
							</div>
						<?php endif; ?>
						<div class="col-lg-2">
							<div class="figure-post__wrapper-button">
							<div class="button-square">
								<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
									<g fill="none" fill-rule="evenodd">
										<rect class="rect" width="100%" height="100%"></rect>
									</g>
								</svg>
								<i class="lnr lnr-arrow-right"></i>
							</div>
							</div>
						</div>
						</div>
					</div>
				</a>
			</div>
		<?php endforeach; ?>
		<?php
	}
}
