<?php

class WPML_Arrigo_Elementor_Testimonials_Slider_Widget extends WPML_Elementor_Module_With_Items {
	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'testimonials';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'testimonial_text', 'testimonial_author_name', 'testimonial_author_position' );
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_title( $field ) {
		switch ( $field ) {
			case 'testimonial_text':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Testimonial', 'arrigo' ), esc_html__( 'Text', 'arrigo' ) );

			case 'testimonial_author_name':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Testimonial', 'arrigo' ), esc_html__( 'Author Name', 'arrigo' ) );

			case 'testimonial_author_position':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Testimonial', 'arrigo' ), esc_html__( 'Author Position', 'arrigo' ) );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'testimonial_text':
				return 'AREA';

			case 'testimonial_author_name':
				return 'LINE';

			case 'testimonial_author_position':
				return 'LINE';

			default:
				return '';
		}
	}
}
