<?php

class WPML_Arrigo_Elementor_Pricing_Table_Widget extends WPML_Elementor_Module_With_Items {
	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'features';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'feature' );
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_title( $field ) {
		switch ( $field ) {
			case 'feature':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Pricing Table', 'arrigo' ), esc_html__( 'Feature', 'arrigo' ) );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'feature':
				return 'LINE';

			default:
				return '';
		}
	}
}
