<?php

/**
 * Add new controls after end of "General Settings"
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'arr_add_elementor_document_settings_after_controls' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'arr_add_elementor_document_settings_after_controls' );
function arr_add_elementor_document_settings_after_controls( \Elementor\Core\DocumentTypes\PageBase $page ) {
	$post_id           = get_the_ID();
	$post_type         = get_post_type( $post_id );
	$is_portfolio_item = $post_type == 'arr_portfolio';
	$is_service_item   = $post_type == 'arr_services';

	$preloader_type         = get_theme_mod( 'preloader_type', 'curtains' );
	$preloader_curtains_num = get_theme_mod( 'preloader_curtains_num', 4 );
	$preloader_style        = get_theme_mod( 'preloader_style', 'preloader_light' );

	/**
	 * Preloader Settings
	 */
	$page->start_controls_section(
		'preloader_section',
		array(
			'label' => _x( 'Page Preloader', 'Elementor Widget Section', 'arrigo' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	/**
	 * Override Preloader
	 */
	$page->add_control(
		'page_preloader_settings',
		array(
			'label'              => _x( 'Override Page Preloader Settings', 'Elementor Widget Section', 'arrigo' ),
			'description'        => _x( 'Use custom preloader settings for this page instead of global customizer settings', 'Elementor Widget Section', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SWITCHER,
			'frontend_available' => true,
		)
	);

	/**
	 * Preloader Type
	 */
	$page->add_control(
		'page_preloader_type',
		array(
			'label'              => _x( 'Type', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SELECT,
			'options'            => array(
				'curtains' => _x( 'Curtains', 'Elementor Widget', 'arrigo' ),
				'fadein'   => _x( 'Fade In', 'Elementor Widget', 'arrigo' ),
			),
			'default'            => esc_attr( $preloader_type ),
			'condition'          => array(
				'page_preloader_settings' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	/**
	 * Number of Curtains
	 */
	$page->add_control(
		'page_preloader_curtains_num',
		array(
			'label'              => _x( 'Number of Curtains', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SLIDER,
			'range'              => array(
				'px' => array(
					'min'  => 1,
					'max'  => 12,
					'step' => 1,
				),
			),
			'default'            => array(
				'unit' => 'px',
				'size' => esc_attr( $preloader_curtains_num ),
			),
			'condition'          => array(
				'page_preloader_settings' => 'yes',
				'page_preloader_type'     => 'curtains',
			),
			'frontend_available' => true,
		)
	);

	/**
	 * Curtains Color
	 */
	$page->add_control(
		'page_preloader_style',
		array(
			'label'              => _x( 'Curtains Color', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SELECT,
			'options'            => array(
				'preloader_dark'   => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
				'preloader_light'  => _x( 'Light', 'Elementor Widget', 'arrigo' ),
				'preloader_accent' => _x( 'Accent', 'Elementor Widget', 'arrigo' ),
			),
			'default'            => esc_attr( $preloader_style ),
			'condition'          => array(
				'page_preloader_settings' => 'yes',
				'page_preloader_type'     => 'curtains',
			),
			'frontend_available' => true,
		)
	);

	$page->end_controls_section();

	$header_theme        = get_theme_mod( 'header_theme', 'header_light' );
	$header_position     = get_theme_mod( 'header_position', 'header_absolute' );
	$header_sticky       = get_theme_mod( 'header_sticky' ) == true ? 'yes' : '';
	$header_logo_version = get_theme_mod( 'header_logo_version', 'default' );
	$menu_style          = get_theme_mod( 'menu_style', 'regular' );

	/**
	 * Header Settings
	 */
	$page->start_controls_section(
		'header_section',
		array(
			'label' => _x( 'Page Header', 'Elementor Widget Section', 'arrigo' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	/**
	 * Override Header
	 */
	$page->add_control(
		'page_header_settings',
		array(
			'label'              => _x( 'Override Page Header Settings', 'Elementor Widget Section', 'arrigo' ),
			'description'        => _x( 'Use custom header settings for this page instead of global customizer settings', 'Elementor Widget Section', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SWITCHER,
			'default'            => $is_portfolio_item ? 'yes' : '',
			'frontend_available' => true,
		)
	);

	/**
	 * Minimal Header
	 */
	if ( $is_portfolio_item ) {
		$page->add_control(
			'page_header_minimal',
			array(
				'label'              => _x( 'Enable Minimal Header', 'Elementor Widget Section', 'arrigo' ),
				'description'        => _x( 'This will remove logo and menu from header and will display only close button.', 'Elementor Widget Section', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'default'            => 'yes',
				'condition'          => array(
					'page_header_settings' => 'yes',
				),
				'frontend_available' => true,
			)
		);
	} else {
		/**
		 * Hide Controls
		 */
		$page->add_control(
			'page_header_minimal',
			array(
				'type'               => \Elementor\Controls_Manager::HIDDEN,
				'default'            => '',
				'frontend_available' => true,
			)
		);
	}

	/**
	 * Color Theme
	 */
	$page->add_control(
		'page_header_theme',
		array(
			'label'              => _x( 'Color Theme', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SELECT,
			'options'            => array(
				'header_dark'   => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
				'header_light'  => _x( 'Light', 'Elementor Widget', 'arrigo' ),
				'header_accent' => _x( 'Accent', 'Elementor Widget', 'arrigo' ),
			),
			'default'            => esc_attr( $header_theme ),
			'condition'          => array(
				'page_header_settings' => 'yes',
				'page_header_minimal!' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	/**
	 * Position
	 */
	$page->add_control(
		'page_header_position',
		array(
			'label'              => _x( 'Position', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SELECT,
			'options'            => array(
				'header_relative' => _x( 'Relative', 'Elementor Widget', 'arrigo' ),
				'header_absolute' => _x( 'Absolute', 'Elementor Widget', 'arrigo' ),
			),
			'default'            => esc_attr( $header_position ),
			'condition'          => array(
				'page_header_settings' => 'yes',
				'page_header_minimal!' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	/**
	 * Sticky
	 */
	$page->add_control(
		'page_header_sticky',
		array(
			'label'              => _x( 'Stick header to the top on page scroll', 'Elementor Widget Section', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SWITCHER,
			'default'            => esc_attr( $header_sticky ),
			'condition'          => array(
				'page_header_settings' => 'yes',
				'page_header_minimal!' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	/**
	 * Menu Style
	 */
	$page->add_control(
		'page_menu_style',
		array(
			'label'              => _x( 'Menu', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SELECT,
			'options'            => array(
				'regular'    => _x( 'Regular', 'Elementor Widget', 'arrigo' ),
				'fullscreen' => _x( 'Fullscreen Overlay', 'Elementor Widget', 'arrigo' ),
			),
			'default'            => esc_attr( $menu_style ),
			'condition'          => array(
				'page_header_settings' => 'yes',
				'page_header_minimal!' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	$page->add_control(
		'page_header_logo_version',
		array(
			'label'              => _x( 'Logo to Display', 'Elementor Widget', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SELECT,
			'options'            => array(
				'default' => _x( 'Default', 'Elementor Widget', 'arrigo' ),
				'alt'     => _x( 'Alternative', 'Elementor Widget', 'arrigo' ),
			),
			'default'            => esc_attr( $header_logo_version ),
			'condition'          => array(
				'page_header_settings' => 'yes',
				'page_header_minimal!' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	$page->end_controls_section();

	/**
	 * Footer Settings
	 */
	$page->start_controls_section(
		'footer_section',
		array(
			'label' => _x( 'Page Footer', 'Elementor Widget Section', 'arrigo' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	if ( $is_portfolio_item ) {

		/**
		 * Item Show Next
		 */
		$page->add_control(
			'portfolio_item_show_next',
			array(
				'label'              => _x( 'Show "Next Portfolio Item" widget after the main content', 'Elementor Widget Section', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'default'            => 'yes',
				'frontend_available' => true,
			)
		);

	}

	/**
	 * Override Footer
	 */
	$page->add_control(
		'page_footer_settings',
		array(
			'label'              => _x( 'Override Page Footer Settings', 'Elementor Widget Section', 'arrigo' ),
			'description'        => _x( 'Use custom footer settings for this page instead of global customizer settings', 'Elementor Widget Section', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SWITCHER,
			'default'            => $is_portfolio_item ? 'yes' : '',
			'frontend_available' => true,
		)
	);

	/**
	 * Footer Hide
	 */
	$page->add_control(
		'page_footer_hide',
		array(
			'label'              => _x( 'Remove Footer from this Page', 'Elementor Widget Section', 'arrigo' ),
			'type'               => \Elementor\Controls_Manager::SWITCHER,
			'default'            => $is_portfolio_item ? 'yes' : '',
			'condition'          => array(
				'page_footer_settings' => 'yes',
			),
			'frontend_available' => true,
		)
	);

	$page->end_controls_section();

	if ( $is_portfolio_item ) {

		/**
		 * Color Theme Settings
		 */
		$page->start_controls_section(
			'page_color_theme_section',
			array(
				'label' => _x( 'Page Color Theme', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Color Theme
		 */
		$page->add_control(
			'portfolio_item_color_theme',
			array(
				'label'              => _x( 'Color Theme', 'Elementor Widget', 'arrigo' ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => array(
					'bg-light' => _x( 'Light', 'Elementor Widget', 'arrigo' ),
					'bg-white' => _x( 'White', 'Elementor Widget', 'arrigo' ),
					'bg-dark'  => _x( 'Dark', 'Elementor Widget', 'arrigo' ),
					'bg-black' => _x( 'Black', 'Elementor Widget', 'arrigo' ),
				),
				'default'            => 'bg-light',
				'frontend_available' => true,
			)
		);

		$page->end_controls_section();
	}
}
