<?php
/**
 * Plugin Name: Arrigo Core
 * Description: Core Plugin for Arrigo WordPress Theme
 * Plugin URI: https://artemsemkin.com/
 * Version: 3.1.0
 * Requires at least: 6.4
 * Requires PHP: 7.0
 * Author: Artem Semkin
 * Update URI: artemsemkin.com
 * Tested up to: 6
 * Text Domain: arrigo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once __DIR__ . '/vendor/autoload.php';

use \Arts\Utilities\Utilities;

$theme_version  = Utilities::get_parent_theme_version();
$plugin_version = Utilities::get_plugin_version( __FILE__ );
$theme_slug     = Utilities::get_parent_theme_slug();

define( 'ARTS_ARRIGO_CORE_THEME_VERSION', $theme_version );
define( 'ARTS_ARRIGO_CORE_PLUGIN_VERSION', $plugin_version );
define( 'ARTS_ARRIGO_CORE_PLUGIN_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'ARTS_ARRIGO_CORE_PLUGIN_URL', untrailingslashit( plugin_dir_url( __FILE__ ) ) );

require_once __DIR__ . '/elementor/arrigo_elementor_extension.php';
require_once __DIR__ . '/elementor/document_settings.php';
require_once __DIR__ . '/inc/cpt.php';
require_once __DIR__ . '/inc/add_custom_mime_types.php';
require_once __DIR__ . '/inc/helper_functions.php';
require_once __DIR__ . '/inc/options.php';
require_once __DIR__ . '/inc/shortcodes.php';
require_once __DIR__ . '/inc/widgets.php';
require_once __DIR__ . '/inc/taxonomies.php';
require_once __DIR__ . '/inc/metaboxes/service_metaboxes.php';
require_once __DIR__ . '/inc/metaboxes/portfolio_item_metaboxes.php';

/**
 * Plugins Updater
 */
new \Arts\PluginsUpdater\Plugin(
	array(
		'theme_id'        => $theme_slug,
		'current_plugin'  => array(
			'update_uri' => 'artemsemkin.com',
			'plugin_id'  => plugin_basename( __FILE__ ),
			'endpoint'   => esc_url( "https://artemsemkin.com/wp-json/edd/v1/update/{$theme_slug}/core-plugin" ),
			'method'     => 'POST',
			'icons'      => array(
				'svg' => esc_url( trailingslashit( ARTS_ARRIGO_CORE_PLUGIN_URL ) . 'assets/icon.svg' ),
				'1x'  => esc_url( trailingslashit( ARTS_ARRIGO_CORE_PLUGIN_URL ) . 'assets/icon-128x128.jpg' ),
				'2x'  => esc_url( trailingslashit( ARTS_ARRIGO_CORE_PLUGIN_URL ) . 'assets/icon-256x256.jpg' ),
			),
			'banners'    => array(
				'low'  => esc_url( trailingslashit( ARTS_ARRIGO_CORE_PLUGIN_URL ) . 'assets/banner-772x250.jpg' ),
				'high' => esc_url( trailingslashit( ARTS_ARRIGO_CORE_PLUGIN_URL ) . 'assets/banner-1544x500.jpg' ),
			),
		),
		'bundled_plugins' => array(
			'acf_pro' => array(
				'plugin_id' => 'advanced-custom-fields-pro/acf.php',
				'endpoint'  => esc_url( 'https://artemsemkin.com/wp-json/edd/v1/update/acf-pro/plugin' ),
				'method'    => 'POST',
			),
		),
	),
	array(
		'error-json-decode'         => 'Failed to decode JSON response.',
		'error-fetch'               => 'Failed to fetch remote data.',
		'license-page-url'          => admin_url( "admin.php?page={$theme_slug}-license" ),
		'license-page-text'         => 'Theme License',
		'license-purchase-url-text' => 'Envato Market',
	)
);

add_action( 'init', 'arr_load_textdomain' );
function arr_load_textdomain() {
	load_plugin_textdomain( 'arrigo' );
}
