{% set itemValue %}
	{% if radio_button_value_handling == "num" %}{{item.button_value}}{% endif %}
	{% if radio_button_value_handling == "text" %}{{item.title|e('html_attr')}}{% endif %}
{% endset %}

<a class="ue-radio-buttons-item {{item.item_repeater_class}}">

  <input id="{{item.item_id}}" class="ue-radio-buttons-item-input" type="radio" value="{{itemValue}}" tabindex="-1">

  <label class="ue-radio-buttons-item-label" for="{{item.item_id}}">
    {% if display_format == "simple" %}<span class="ue-radio-buttons-item-label-container"></span>{% endif %}
    
    {% if (display_format == "simple") or (display_format == "buttons") %}{{item.title|raw}}{% endif %}
    
    {% if display_format == "image" %}
      <img src="{{item.radio_image}}" alt="{{item.radio_image_alt}}" title="{{item.radio_image_title}}" {{item.radio_image_attributes|raw}}>
      <span class="ue-radio-buttons-item-title">{{item.title}}</span>
    {% endif %}
    
  </label>

</a>