{{ ucfunc("put_docready_start") }}
		
  var ueButton = jQuery("#{{uc_id}} .ue-dropbar-button")[0];
  var ueDropbarContent = jQuery("#{{uc_id}} .ue-dropbar-content")[0];
  
  {% if content_type == "id" %}	
    ueDropbar("{{uc_id}}");
  {% endif %}
  
  // Responsive Offset Calculation
  function responsiveOffsets() {
    if (window.matchMedia('(max-width: 767px)').matches) {
        return [{{horizontal_offset_mobile_nounit}}, {{vertical_offset_mobile_nounit}}]; // Mobile
    } else if (window.matchMedia('(max-width: 1023px)').matches) {
        return [{{horizontal_offset_tablet_nounit}}, {{vertical_offset_tablet_nounit}}]; // Tablet
    } else {
        return [{{horizontal_offset_nounit}}, {{vertical_offset_nounit}}]; // Desktop
    }
  }

   // Create a Popper instance
   var popperInstance = Popper.createPopper(ueButton, ueDropbarContent, {
      placement: '{{placement}}',
      strategy: 'absolute',
      modifiers: [
          {
              name: 'offset',
              options: {
                  offset: responsiveOffsets(),
              },
          },
          {
              name: 'flip',
              options: {
                  fallbackPlacements: [{% for value in fallback_placements %}'{{value}}',{% endfor %}], 
              },
          },
          {
              name: 'preventOverflow',
              options: {
                 padding: 5,
              },
          },
          
      ],
   });
   
    // Update Popper instance on window resize
    jQuery(window).on('resize', function () {
        popperInstance.setOptions({
            modifiers: [
                {
                    name: 'offset',
                    options: {
                        offset: responsiveOffsets(),
                    },
                },
            ],
        });

        popperInstance.update(); // Recalculate position
    });
   
    // Function to show the dropbar
    function showDropdown() {
      ueDropbarContent.classList.add('ue-dropbar-active');
      ueButton.classList.add('ue-dropbutton-active');
      popperInstance.update(); // Update Popper's position
    }

    // Function to hide the dropbar
    function hideDropdown() {
      ueDropbarContent.classList.remove('ue-dropbar-active');
      ueButton.classList.remove('ue-dropbutton-active');
    }

  {% if trigger == "click" %}
    // Toggle on click
    jQuery(ueButton).on('click', function () {
      if (ueDropbarContent.classList.contains('ue-dropbar-active')) {
        hideDropdown();
      } else {
        showDropdown();
      }
    });
  {% endif %}

  {% if trigger == "hover" %}
    // Show dropdown on hover (desktop) or on tap (mobile)
    jQuery(ueButton).on('mouseenter', function (e) {
      e.preventDefault(); // Prevent the default behavior to avoid unwanted scrolling
      showDropdown();
    });

    // Hide dropdown when not hovering (desktop)
    jQuery(ueButton).on('mouseleave', function () {
      hideDropdown();
    });

    // Keep the dropdown open when hovering over it (desktop)
    jQuery(ueDropbarContent).on('mouseenter', function () {
      showDropdown();
    });

    // Hide the dropdown when the mouse leaves the dropdown area (desktop)
    jQuery(ueDropbarContent).on('mouseleave', function () {
      hideDropdown();
    });
  {% endif %}

  {% if outside_click_hide_dropbar == "true" %}
    // Additional check to close dropdown on body click for mobile
    jQuery(document).on('click mouseenter', function (e) {
      if (!ueButton.contains(e.target) && !ueDropbarContent.contains(e.target)) {
          hideDropdown();
      }
    });
  {% endif %} 
    	
{{ ucfunc("put_docready_end") }}