#{{uc_id}}{
  position:relative;
  display:flex;
  flex-direction: row;
  align-items:center;
}

#{{uc_id}} .ue-dropbar-button{
  position: relative;
  display: flex;
  flex-direction: row;
  align-items: center;
  justify-content: center;
  text-align:center;
  outline:none;
  transition-property: all;
}

{% if show_icon != "no" %}
  #{{uc_id}} .ue-dropbar-button svg{
    width:1em;
    height:1em;
  }

  #{{uc_id}} .ue-dropbar-button span{
    justify-content: center;
    align-items: center;
  }

  {% if different_active_icon == "true" %}
  #{{uc_id}} .ue-drop-icon-inactive{
    display: flex;
  }
  #{{uc_id}} .ue-dropbar-button.ue-dropbutton-active .ue-drop-icon-inactive{
    display:none;
  }
  #{{uc_id}} .ue-drop-icon-active{
    display:none;
  }
  #{{uc_id}} .ue-dropbar-button.ue-dropbutton-active .ue-drop-icon-active{
    display: flex;
  }
  {% endif %}
{% endif %}

#{{uc_id}} .ue-dropbar-content{
  display: flex;
  flex-direction: column;
  {% if width_type == "auto" %}
  width: max-content;
  {% endif %}
  {% if width_type == "custom" %}
  max-width: 95vw;
  {% endif %}
  visibility:hidden;
  opacity:0;
  pointer-events:none;
  position: absolute; 
  
  {% if entrance_animation == "in-out-left" %}
    translate: -10px 0px;
  {% elseif entrance_animation == "in-out-right" %}
    translate:  10px 0px;
  {% elseif entrance_animation == "in-out-top" %}
    translate:  0px -10px;
  {% elseif entrance_animation == "in-out-bottom" %}
    translate:  0px  10px;
  {% elseif entrance_animation == "none" %}
    translate:  0px  0px;
  {% endif %}
  
}
#{{uc_id}} .ue-dropbar-content.ue-dropbar-active {
  display: flex;
  visibility:visible;
  opacity:1;
  translate: 0px 0px;
  pointer-events:all;
}

{% if content_type == "id" %}
#{{uc_id}} .uc-editor-message.uc-error{
  padding:10px;
  font-size:14px;
  color: red;
}
#{{uc_id}} .uc-editor-message.uc-success{
  padding:10px;
  font-size:14px;
  color: green;
} 
{% endif %}

{% if uc_inside_editor == "no" %}
 #{{element_id|raw}}:not(#{{uc_id}} #{{element_id|raw}}){
 	display: none;
 }
{% endif %}

{% if hide_dropbar_if_button_is_hidden == "true" %}
#{{uc_id}} .ue-dropbar-content[data-popper-reference-hidden] {
  visibility:hidden;
  opacity:0;
  pointer-events:none;
}
{% endif %}

body{
  overflow-x:hidden;
}